const customer = [
  {
    fatherTitle: '客户',
    type: 'object',
    key: 'personInfo',
    data: [
      {
        label: '姓氏',
        key: 'lastName',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 5,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '名字',
        key: 'firstName',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 10,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '姓名',
        key: 'name',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 15,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '姓氏拼音',
        key: 'lastNamePinyin',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '姓名拼音',
        key: 'pinyin',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '名字-英文',
        key: 'firstNamePinyin',
        type: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '称谓',
        key: 'title',
        type: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_customer_title',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '性别',
        key: 'gender',
        type: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_gender',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '生日',
        key: 'birthdate',
        type: 'DatePicker',
        required: false,
        disabled: false,
        placeholder: '请选择',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '年龄',
        key: 'age',
        type: 'Input',
        inputType: 'number',
        maxLength: 30,
        required: true,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '移动电话',
        key: 'phone',
        type: 'arrowRight',
        required: true,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        phone: {},
        code: 'areaCode',
        value: '',
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '邮箱',
        key: 'email',
        type: 'Input',
        inputType: 'text',
        maxLength: 30,
        required: true,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否吸烟',
        key: 'smoke',
        type: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '吸烟数量(支/天)',
        key: 'smokeQuantity',
        type: 'Input',
        inputType: 'number',
        maxLength: 30,
        required: false,
        disabled: false,
        placeholder: '请输入',
        show: false,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      // {
      //   label: '公司类型',
      //   key: 'companyType',
      //   type: 'Select',
      //   required: false,
      //   disabled: false,
      //   placeholder: '请选择',
      //   dictType: 'sys_status',
      //   show: true
      // },
      {
        label: '客户类型',
        key: 'customerType',
        type: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_customer_type',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      // {
      //   label: '客户来源',
      //   key: 'source',
      //   type: 'Select',
      //   required: false,
      //   disabled: false,
      //   placeholder: '请选择',
      //   dictType: 'sys_status',
      //   show: true
      // },
      {
        label: '行业',
        key: 'companyType',
        type: 'Input',
        inputType: 'text',
        maxLength: 300,
        required: true,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  {
    fatherTitle: '基本情况',
    type: 'object',
    key: 'basic',
    // description: '证件信息至少填写一项',
    data: [
      {
        label: '婚姻状况',
        key: 'marriage',
        type: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_marriage',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '国籍(国家/地区)',
        key: 'country',
        type: 'arrowRight',
        required: true,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'country',
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '出生地',
        key: 'birthplace',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入出生地(省市)',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '教育程度',
        key: 'education',
        type: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_education',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '住宅电话',
        key: 'residenceTelephone',
        type: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        residenceTelephone: {},
        code: 'residenceAreaCode',
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '固定电话',
        key: 'fixedPhone',
        type: 'Input',
        inputType: 'number',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否长期出国',
        key: 'longtimeAbroad',
        type: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '通讯地址',
        key: 'residenceAddress',
        type: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        residenceAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '住宅地址',
        key: 'residentialAddress',
        type: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        residentialAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '邮寄地址',
        key: 'mailingAddress',
        type: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        mailingAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  {
    fatherTitle: '证件信息',
    type: 'object',
    key: 'pid',
    description: '证件信息至少填写一项',
    data: [
      {
        label: '证件类型',
        key: 'idType',
        type: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_id_type',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '证件号码',
        key: 'idCard',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  {
    fatherTitle: '公司信息',
    type: 'object',
    key: 'companyInfo',
    data: [
      {
        label: '公司名称',
        key: 'companyName',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司电话',
        key: 'companyTelephone',
        type: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        companyTelephone: {},
        code: 'companyAreaCode',
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '职位',
        key: 'position',
        type: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '总工作年期',
        key: 'workYear',
        type: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '现时每月收入',
        key: 'salary',
        type: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司地址',
        key: 'companyAddress',
        type: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        companyAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 8, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  }
]
export default customer
