// dictUtils.js
import request from '@/utils/request' 

// 全局缓存：key 为 dictType，value 为 { label: value } 映射对象
const dictCache = new Map()

// 批量加载字典（支持多个 type）
export async function loadDicts(typeList) {
  // 过滤已缓存的类型，避免重复请求
  const needLoadTypes = typeList.filter(type => !dictCache.has(type))
  if (needLoadTypes.length === 0) return

  try {
    const res = await request({
      url: '/user/api/sysDict/type/list', // 替换为你的实际接口地址
      method: 'POST',
      data: {
        typeList: needLoadTypes
      }
    })

// 替换 loadDicts 中的缓存部分
if (res.code === 200 && Array.isArray(res.data)) {
  for (const dict of res.data) {
    const { dictType, dictItemList = [] } = dict
    if (!dictType) continue

    // 缓存完整列表（并可选排序 + 过滤）
    const validItems = dictItemList
      .filter(item => item.status === 1) // 只取启用的
      .sort((a, b) => a.orderNum - b.orderNum) // 按序号排序

    dictCache.set(dictType, validItems) // 👈 缓存完整 item 列表
  }
}
  } catch (error) {
    console.error('字典加载失败:', error)
    throw error
  }
}

// 可选：提供清除缓存方法（用于权限切换等场景）
export function clearDictCache() {
  dictCache.clear()
}
export function getDictOptions(dictType) {
  const items = dictCache.get(dictType) || []
//   console.log('getDictOptions',items)
  return items.map(item => ({
    value: item.itemValue,
    label: item.itemLabel
    // 如果需要，还可以加其他字段：disabled, key 等
  }))
}

// 同时更新 getDictLabel
export function getDictLabel(dictType, value) {
  const items = dictCache.get(dictType) || []
  const item = items.find(i => i.itemValue === value)
  return item ? item.itemLabel : value
}