const fnaForm = [
  {
    fatherTitle: '个人资料',
    type: 'object',
    key: 'personalData',
    child: 'no', //没有子级dom，直接展示
    data: [
      {
        label: '陪同顾问姓名',
        key: 'accountName',
        domType: 'Select',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        dictType: 'csf_customer_title',
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '理财顾问注册编号',
        key: 'registrationNumber',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '130px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8, //栅格布局份数,
        labelWidth: '140px'
      },
      {
        label: '理财顾问内部编码',
        key: 'number',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '130px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '客户姓名',
        key: 'customerName',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '税务国家',
        key: 'taxCountry',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '就业情况',
        key: 'employment',
        domType: 'Select',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        dictType: 'csf_customer_title',
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否退休',
        key: 'isRetired',
        domType: 'Select',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        dictType: 'csf_customer_title',
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '退休年龄',
        key: 'retiredAge',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '其他就业情况',
        key: 'otherEmployment',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  //家庭状况
  {
    fatherTitle: '家庭状况',
    type: 'object',
    key: 'familyMembers',
    child: 'yes', //有子级dom,需要循环展示
    addFamilyChildren: true, //是否可以新增子级dom
    data: [
      {
        type: '1',
        childTitle: '父亲',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '年龄',
            key: 'age',
            domType: 'Input',
            inputType: 'number',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '是否需要供养',
            key: 'needProvide',
            domType: 'Select',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'sys_no_yes',
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      },
      {
        type: '2',
        childTitle: '母亲',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '年龄',
            key: 'age',
            domType: 'Input',
            inputType: 'number',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '是否需要供养',
            key: 'needProvide',
            domType: 'Select',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'sys_no_yes',
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      },
      {
        type: '3',
        childTitle: '配偶',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '年龄',
            key: 'age',
            domType: 'Input',
            inputType: 'number',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '是否需要供养',
            key: 'needProvide',
            domType: 'Select',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'sys_no_yes',
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      }
    ]
  },
  //财务需要分析
  {
    fatherTitle: '财务需要分析',
    type: 'object',
    key: 'existingSecurityOwner',
    dataLength: 5, //设置dataLength,用于控制子级dom的个数，子级保存一个样例数据，便于加子级数据
    child: 'yes', //有子级dom,需要循环展示
    data: [
      {
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        childTitle: '保单持有人个人已有保障',
        children: [
          {
            label: '保险公司',
            key: 'insurer',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保障类型',
            key: 'insuranceType',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保额',
            key: 'sumInsured',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '币种',
            key: 'currency',
            domType: 'Select',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'bx_currency_type',
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保单签发日期',
            key: 'policyIssueDate',
            domType: 'DatePicker',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      }
      // {
      //   key: 'flow',
      //   childTitle: '',
      //   children: [
      //     {
      //       label: '流动资产种类',
      //       key: 'liquidAssetType',
      //       domType: 'Checkbox',
      //       required: false,
      //       maxLength: 300,
      //       disabled: false,
      //       placeholder: '请输入',
      //       show: true
      //     },
      //     {
      //       label: '',
      //       key: 'otherLiquidAsset',
      //       domType: 'Input',
      //       required: false,
      //       maxLength: 300,
      //       disabled: false,
      //       placeholder: '请输入',
      //       show: true
      //     }
      //   ]
      // }
    ]
  },
  //受保人个人已有保障
  {
    type: 'object',
    key: 'existingSecurityInsured',
    dataLength: 5, //设置dataLength,用于控制子级dom的个数，子级保存一个样例数据，便于加子级数据
    child: 'yes', //有子级dom,需要循环展示
    data: [
      {
        childTitle: '受保人个人已有保障',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '保险公司',
            key: 'insurer',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保障类型',
            key: 'insuranceType',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保额',
            key: 'sumInsured',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '币种',
            key: 'currency',
            domType: 'Select',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'bx_currency_type',
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保单签发日期',
            key: 'policyIssueDate',
            domType: 'DatePicker',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      }
    ]
  },
  {
    key: 'incom',
    type: 'object',
    child: 'no',
    data: [
      {
        label:
          '在过去24个月里，你从所有所得的收入来源所得的平均每月收入为?(包括薪金、花红、佣金、其他薪酬红利、银行存款利息、债券利息及股息等',
        subLable: '金额(HKD)', //子标题
        key: 'monthlyIncome',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '800px', //标签宽度
        sm: 24, //栅格布局份数
        lg: 24, //栅格布局份数
        labelPosition: 'top', //标签的位置
        layout: 'column'
      },
      {
        label: '过去24个月每月里，你每月的平均开支为?',
        subLable: '金额(HKD)', //子标题
        key: 'monthlyExpense',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '200px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 12, //栅格布局份数
        layout: 'row'
      },
      {
        label: '您现时的累积流动资产约有多少?',
        subLable: '金额(HKD)', //子标题
        key: 'liquidAssets',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '200px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 12 //栅格布局份数
      }
    ]
  }
  // {
  //   fatherTitle: '',
  //   secondTitle: '保单持有人资产',
  //   type: 'object',
  //   key: 'ownerAssets',
  //   data: [
  //     {
  //       key: 'primaryResidence',
  //       childTitle: '自住用途之房地產',
  //       childLength: 5,
  //       children: [
  //         {
  //           label: '地址',
  //           key: 'address',
  //           domType: 'Input',
  //           inputType: 'text',
  //           required: false,
  //           maxLength: 300,
  //           disabled: false,
  //           placeholder: '请输入',
  //           show: true
  //         },
  //         {
  //           label: '市值',
  //           key: 'marketValue',
  //           domType: 'Input',
  //           inputType: 'text',
  //           required: false,
  //           maxLength: 300,
  //           disabled: false,
  //           placeholder: '请输入',
  //           show: true
  //         },

  //         {
  //           label: '币种',
  //           key: 'currency',
  //           domType: 'Select',
  //           inputType: 'text',
  //           required: false,
  //           maxLength: 300,
  //           disabled: false,
  //           placeholder: '请输入',
  //           show: true,
  //           dictType: 'bx_currency_type'
  //         }
  //       ]
  //     },
  //     {
  //       key: 'investment',
  //       childTitle: '投資房地產',
  //       childLength: 2,
  //       children: [
  //         {
  //           label: '地址',
  //           key: 'address',
  //           domType: 'Input',
  //           inputType: 'text',
  //           required: false,
  //           maxLength: 300,
  //           disabled: false,
  //           placeholder: '请输入',
  //           show: true
  //         },
  //         {
  //           label: '市值',
  //           key: 'marketValue',
  //           domType: 'Input',
  //           inputType: 'text',
  //           required: false,
  //           maxLength: 300,
  //           disabled: false,
  //           placeholder: '请输入',
  //           show: true
  //         },

  //         {
  //           label: '币种',
  //           key: 'currency',
  //           domType: 'Select',
  //           inputType: 'text',
  //           required: false,
  //           maxLength: 300,
  //           disabled: false,
  //           placeholder: '请输入',
  //           show: true,
  //           dictType: 'bx_currency_type'
  //         }
  //       ]
  //     }
  //   ]
  // },
  // {
  //   fatherTitle: '',
  //   secondTitle: '公司业务资料',
  //   type: 'object',
  //   key: 'companyBusinessData',
  //   data: [
  //     {
  //       label: '币种',
  //       key: 'currency',
  //       domType: 'Select',
  //       required: true,
  //       maxLength: 30,
  //       disabled: false,
  //       placeholder: '请输入',
  //       show: true,
  //       dictType: 'bx_currency_type'
  //     },
  //     {
  //       label: '公司過去兩年平均純利 (HKD)',
  //       key: 'averageNetProfit',
  //       domType: 'Input',
  //       inputType: 'text',
  //       required: true,
  //       maxLength: 30,
  //       disabled: false,
  //       placeholder: '请输入',
  //       show: true
  //     },
  //     {
  //       label: '公司現時大約的總資產 (HKD)',
  //       key: 'estimatedTotalAssets',
  //       domType: 'Input',
  //       inputType: 'text',
  //       required: true,
  //       maxLength: 30,
  //       disabled: false,
  //       placeholder: '请输入',
  //       show: true
  //     },
  //     {
  //       label: '資產所佔百分比 (%)',
  //       key: 'assetPercentage',
  //       domType: 'Input',
  //       inputType: 'text',
  //       required: true,
  //       maxLength: 30,
  //       disabled: false,
  //       placeholder: '请输入',
  //       show: true
  //     }
  //   ]
  // },
  // {
  //   fatherTitle: '',
  //   secondTitle: '首期及续保保费的财富来源',
  //   type: 'object',
  //   key: 'premiumFundingSource',
  //   data: [
  //     {
  //       label: '',
  //       key: 'premiumFundingSource',
  //       domType: 'Radio',
  //       required: true,
  //       maxLength: 30,
  //       disabled: false,
  //       placeholder: '请输入',
  //       show: true,
  //       dictType: 'csf_premium_funding_source'
  //     }
  //   ]
  // }
]
export default fnaForm
