import useDictStore from '@/store/modules/dict'
import { getDicts } from '@/api/system/dict/data'
import { getMoreDicts } from '@/api/common'

/**
 * 获取字典数据
 */
export function useDict(...args) {
  const res = ref({})
  return (() => {
    args.forEach((dictType, index) => {
      res.value[dictType] = []
      const dicts = useDictStore().getDict(dictType)
      // if (dicts) {
      //   res.value[dictType] = dicts
      // } else {
      //   getDicts(dictType).then(resp => {
      //     res.value[dictType] = resp.data.map(p => ({ label: p.itemLabel, value: p.itemValue }))
      //     useDictStore().setDict(dictType, res.value[dictType])
      //   })
      // }
      getDicts(dictType).then(resp => {
        res.value[dictType] = resp.data.map(p => ({ label: p.itemLabel, value: p.itemValue }))
        useDictStore().setDict(dictType, res.value[dictType])
      })
    })
    return toRefs(res.value)
  })()
}
/**
 * 获取多个字典数据
 */
export function useDictLists(typeLists) {
  let params = { typeList: typeLists }
  console.log(params)
  let dictArray = []
  return (() => {
    getMoreDicts(params).then(resp => {
      if (resp.code === 200) {
        dictArray = resp.data.map(item => {
          item.dictItemList.forEach(dict => {
            dict.label = dict.itemLabel
            if (item.dictType == 'sys_no_yes') {
              dict.value = Number(dict.itemValue)
            } else {
              dict.value = dict.itemValue
            }
          })
          return item
        })
        useDictStore().setDictTypeLists(dictArray)
      }
    })
  })()
}