const customer = [
  // 与投保人关系-在受保人中显示
  {
    fatherTitle: '与投保人关系',
    showTitle: false,
    type: 'object',
    key: 'policyholderRel',
    anchorKey: 'policyholderRel',
    showTable: false,
    showMoudle: false,
    data: [
      {
        label: '与投保人关系',
        key: 'policyholderRel',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_rel',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  // 基础信息
  {
    fatherTitle: '基础信息',
    type: 'object',
    key: 'personInfo',
    anchorKey: 'personInfo',
    showTable: false,
    showMoudle: true,
    data: [
      {
        label: '名字(中文)',
        key: 'nameCn',
        domType: 'Input',
        unit: '历史客户',
        unitColor: 'rgba(0, 82, 217, 1)',
        inputType: 'text',
        required: true,
        maxLength: 15,
        disabled: false,
        placeholder: '请输入2~6位汉字',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '姓名(拼音/英文)',
        key: 'namePyEn',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '证件类型',
        key: 'documentType',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_id_type',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '证件号码',
        key: 'idNumber',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '性别',
        key: 'gender',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_gender',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '生日',
        key: 'birthday',
        domType: 'DatePicker',
        required: true,
        disabled: false,
        placeholder: '请选择',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '年龄',
        key: 'age',
        domType: 'Input',
        inputType: 'number',
        maxLength: 30,
        required: true,
        disabled: true,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '国籍(国家/地区)',
        key: 'nationality',
        domType: 'arrowRight',
        required: true,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'country',
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '出生地',
        key: 'birthplace',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入出生地(省市)',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否拥有其他国家公民身份',
        key: 'isOtherCountry',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否吸烟',
        key: 'smokingStatus',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '婚姻状况',
        key: 'maritalStatus',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_marriage',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '教育程度',
        key: 'educationLevel',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_education',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否退休',
        key: 'isRetirement',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '退休年龄',
        key: 'retirementAge',
        domType: 'Input',
        inputType: 'number',
        maxLength: 30,
        required: false,
        disabled: false,
        placeholder: '请输入',
        show: false,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '风险偏好',
        key: 'riskAppetite',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_risk',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '体重(KG)',
        key: 'weight',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入身高(kg)',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '身高(CM)',
        key: 'height',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入身高(cm)',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: 'BMI',
        key: 'bmi',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: true,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '受供养人数目',
        key: 'dependentsNum',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: false,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  // 税务信息
  {
    fatherTitle: '税务信息',
    keyType: 'Array', //用于表单收集值时，判断是数组还是对象
    key: 'apiTaxationDtoList',
    anchorKey: 'apiTaxationDtoList',
    moudleType: 'apiTaxationDtoList',
    dataLength: 1, //设置dataLength,用于控制子级dom的个数，子级保存一个样例数据，便于加子级数据
    showMoudle: true,
    showTable: true,
    addChildren: true, //是否可以新增子级dom
    addChildrenTxt: '税务', //新增按钮得文本
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    isOpen: false, //dom是否展开
    data: [
      // {
      //   id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
      //   span: 24, //栅格布局份数
      //   taxCountry: '',
      //   taxId: ''
      // }
    ]
  },
  // 联系信息
  {
    fatherTitle: '联系信息',
    type: 'object',
    key: 'contactInfo',
    anchorKey: 'contactInfo',
    showTable: false,
    showMoudle: true,
    data: [
      {
        label: '移动电话',
        key: 'mobile',
        domType: 'arrowRight',
        required: true,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        mobile: {},
        code: 'mobileCode',
        value: '',
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '住宅电话',
        key: 'residenceMobile',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        residenceMobile: {},
        code: 'residenceMobileCode',
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '固定电话',
        key: 'landline',
        domType: 'Input',
        inputType: 'number',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '邮箱',
        key: 'email',
        domType: 'Input',
        inputType: 'text',
        maxLength: 30,
        required: false,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '证件地址',
        key: 'certificateAddress',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '通讯地址',
        key: 'mailingAddress',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        mailingAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '住宅地址',
        key: 'residentialAddress',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        residentialAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '通讯地址邮政编号',
        key: 'mailingAddressCode',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },

  // 工作信息
  {
    fatherTitle: '工作信息',
    type: 'object',
    key: 'companyInfo',
    anchorKey: 'companyInfo',
    showTable: false,
    showMoudle: true,
    data: [
      {
        label: '就业情况',
        key: 'employmentStatus',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司/学校名称',
        key: 'csName',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '行业',
        key: 'industry',
        domType: 'Input',
        inputType: 'text',
        maxLength: 300,
        required: false,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '现时每月收入',
        key: 'currentMonthlyIncome',
        domType: 'Input',
        unit: 'HKD',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '总工作年期',
        key: 'totalWorkingYears',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '受雇于现职年期',
        key: 'currentTenure',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '职位',
        key: 'position',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司电话',
        key: 'companyMobile',
        commonKey: true,
        customerKey: 'companyTelephone',
        customerCode: 'companyAreaCode',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        companyMobile: {}, //带有区号得电话一定要有一个和key一样得对象用于收集区号和号码
        code: 'companyMobileCode',
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '180px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司地址',
        key: 'companyAddress',
        customerKey: 'companyAddress',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        companyAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司地址邮编号',
        key: 'companyAddressCode',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  // 财务信息
  {
    fatherTitle: '财务信息',
    type: 'object',
    key: 'financeInfo',
    anchorKey: 'financeInfo',
    showTable: false,
    showMoudle: true,
    data: [
      {
        label: '平均每月收入',
        key: 'monthIncome',
        domType: 'Input',
        unit: 'HKD',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入平均每月收入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '平均每月支出',
        key: 'monthExpenditure',
        domType: 'Input',
        unit: 'HKD',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入平均每月支出',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '总流动资产',
        key: 'totalCurrentAssets',
        domType: 'Input',
        unit: 'HKD',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '总负债额',
        key: 'totalDebt',
        domType: 'Input',
        unit: 'HKD',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  //其他信息
  {
    fatherTitle: '其他信息',
    type: 'object',
    key: 'otherInfo',
    anchorKey: 'otherInfo',
    showTable: false,
    showMoudle: true, //模块是否展示
    data: [
      {
        label: '旅行',
        key: 'travel',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '运动',
        key: 'exercise',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_exercise',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '游戏',
        key: 'game',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_game',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '电影/戏剧',
        key: 'movieDrama',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_movie',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '美食',
        key: 'delicacy',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  }
]
export default customer
