import request from '@/utils/request'

// 分页获取保单业务回执列表
export function getPolicyReceiptList(data) {
  return request({
    url: '/csf/api/policyReceipt/page',
    method: 'post',
    data: data
  })
}
// 添加保单业务回执
export function addPolicyReceipt(data) {
  return request({
    url: '/csf/api/policyReceipt/add',
    method: 'post',
    data: data
  })
}
//编辑保单业务回执
export function EditPolicyReceipt(data) {
  return request({
    url: '/csf/api/policyReceipt/edit',
    method: 'post',
    data: data
  })
}
//获取保单业务回执详情
export function getPolicyReceipt(policyReceiptBizId) {
  return request({
    url: '/csf/api/policyReceipt/detail?policyReceiptBizId=' + policyReceiptBizId,
    method: 'get'
  })
}
//保费对账列表
export function premiumReconciliationList(data) {
  return request({
    url: '/csf/api/premiumReconciliation/page',
    method: 'post',
    data: data
  })
}
//获取保费对账详情
export function getPremiumReconciliationInfo(premiumReconciliationBizId) {
  return request({
    url: `/csf/api/premiumReconciliation/detail?premiumReconciliationBizId=${premiumReconciliationBizId}`,
    method: 'get'
  })
}
//新增保费对账
export function addPremiumReconciliation(data) {
  return request({
    url: '/csf/api/premiumReconciliation/add',
    method: 'post',
    data: data
  })
}
//编辑提交保费对账
export function editPremiumReconciliation(data) {
  return request({
    url: '/csf/api/premiumReconciliation/edit',
    method: 'put',
    data: data
  })
}
//保费对账编辑单个汇款记录
export function editPremiumRemittance(data) {
  return request({
    url: '/csf/api/premiumRemittance/edit',
    method: 'put',
    data: data
  })
}
//保费对账删除一条汇款记录
export function deletePremiumRemittance(premiumRemittanceBizId) {
  return request({
    url: `/csf/api/premiumRemittance/del?premiumRemittanceBizId=${premiumRemittanceBizId}`,
    method: 'delete'
  })
}
//保费对账删除汇款记录中得其他资料附件
export function deletePremiumRemittanceFile(premiumRemittanceFileBizId) {
  return request({
    url: `/csf/api/premiumRemittanceFile/del?premiumRemittanceFileBizId=${premiumRemittanceFileBizId}`,
    method: 'delete'
  })
}
//保费对账其他资料附件列表
export function getPremiumRemittanceFileList(data) {
  return request({
    url: '/csf/api/premiumRemittanceFile/page',
    method: 'post',
    data: data
  })
}
//编辑单个保费对账汇款记录
export function editSiglePremiumRemittance(data) {
  return request({
    url: '/csf/api/premiumRemittance/edit',
    method: 'put',
    data: data
  })
}
//保费对账汇款记录列表
export function getPremiumRemittanceListApi(data) {
  return request({
    url: '/csf/api/premiumRemittance/page',
    method: 'post',
    data: data
  })
}
//检查保单号是否已经提交过保费对账
export function getCheckPolicyNoApi(policyNo) {
  return request({
    url: `/csf/api/premiumReconciliation/check/reconciliation/complete?policyNo=${policyNo}`,
    method: 'get'
  })
}
// 保费对账认定结果计算待付金额
export function getRemainingUnpaidAmount(data) {
  return request({
    url: '/csf/api/premiumReconciliation/calculate/remainingUnpaidAmount',
    method: 'post',
    data: data
  })
}
//提交保费对账认定结果
export function submitResult(data) {
  return request({
    url: '/csf/api/premiumReconciliation/edit/result',
    method: 'put',
    data: data
  })
}
//单个新增保费对账汇款记录
export function addSinglePremiumRemittance(data) {
  return request({
    url: '/csf/api/premiumRemittance/add',
    method: 'post',
    data: data
  })
}
