import request from '@/utils/request'

// 查询角色列表
export function listRole(data) {
  return request({
    url: '/user/api/sysRole/page',
    method: 'post',
    data: data
  })
}

// 新增角色
export function addRole(data) {
  return request({
    url: '/user/api/sysRole/add',
    method: 'post',
    data: data
  })
}

// 修改角色
export function roleUpdate(data) {
  return request({
    url: '/user/api/sysRole/edit',
    method: 'put',
    data: data
  })
}

// 删除角色
export function delRole(roleId) {
  return request({
    url: '/system/role/' + roleId,
    method: 'delete'
  })
}

// 编辑角色状态
export function roleStatusChange(roleBizId, status) {
  return request({
    url: `/user/api/sysRole/edit/status?roleBizId=${roleBizId}&status=${status}`,
    method: 'patch'
  })
}

// 查询角色详情
export function getRoleDetail(roleBizId) {
  return request({
    url: `/user/api/sysRole/detail?roleBizId=${roleBizId}`,
    method: 'get'
  })
}

//作用域切换搜索
export function searchScopeList(data) {
  return request({
    url: '/user/api/sysUser/scope/page',
    method: 'post',
    data: data
  })
}
