import request from '@/utils/request'

// 查询预约列表
export function getAppointmentList(data) {
  return request({
    url: '/csf/api/appointment/page',
    method: 'post',
    data: data
  })
}
// 导出预约信息
export function getAppointmentExprot(appointmentBizId) {
  return request({
    url: `/csf/api/appointmentFile/excel/export/appointment?appointmentBizId=${appointmentBizId}`,
    method: 'get'
  })
}
// 导出行程单信息
export function getItineraryExprot(appointmentBizId) {
  return request({
    url: `/csf/api/appointmentFile/pdf/itinerary?appointmentBizId=${appointmentBizId}`,
    method: 'get'
  })
}

// 新增预约
export function addAppointment(data) {
  return request({
    url: '/csf/api/appointment/add',
    method: 'post',
    data: data
  })
}
// 编辑预约
export function editAppointmentDetail(data) {
  return request({
    url: '/csf/api/appointment/edit',
    method: 'put',
    data: data
  })
}
// 暂存预约
export function storageAppointment(data) {
  return request({
    url: '/csf/api/appointment/add/storage',
    method: 'post',
    data: data
  })
}
// 获取预约详情
export function getAppointmentDetail(appointmentBizId) {
  return request({
    url: `/csf/api/appointment/detail?appointmentBizId=${appointmentBizId}`,
    method: 'get'
  })
}
// 获取行程单详情
export function getItineraryDetail(appointmentBizId) {
  return request({
    url: `/csf/api/appointmentFile/pdf/itinerary/detail?appointmentBizId=${appointmentBizId}`,
    method: 'get'
  })
}

// 获取预约健康信息数据
export function getQuestionnaires(appointmentBizId) {
  return request({
    url: `/question/api/questionnaires/detail?questionnaireBizId=questionnaires_1001&objectBizId=${appointmentBizId}`,
    method: 'get'
  })
}
// 预约-提交健康信息模块
export function saveQuestionnaires(data) {
  return request({
    url: '/question/api/questionnaires/answer/save',
    method: 'post',
    data: data
  })
}
// 预约-提交预约信息模块
export function editAppointmentInfo(data) {
  return request({
    url: '/csf/api/appointment/single/edit',
    method: 'put',
    data: data
  })
}
// 预约-生成新单
export function newPolicy(data) {
  return request({
    url: '/csf/api/appointment/edit/confirm/time',
    method: 'put',
    data: data
  })
}
// 预约-提交产品计划模块
export function editProductPlanInfo(data) {
  return request({
    url: '/csf/api/productPlan/edit/plan',
    method: 'put',
    data: data
  })
}
// 删除附加险
export function delAdditional(additionalBizId) {
  return request({
    url: '/csf/api/additional/del?additionalBizId=' + additionalBizId,
    method: 'delete'
  })
}
// 预约-提交投保人模块
export function editPolicyholderInfo(data) {
  return request({
    url: '/csf/api/policyholder/edit',
    method: 'put',
    data: data
  })
}
// 预约-提交受保人模块
export function editInsurantInfo(data) {
  return request({
    url: '/csf/api/insurant/edit',
    method: 'put',
    data: data
  })
}
// 预约-提交第二持有人模块
export function editSecondHolderInfo(data) {
  return request({
    url: '/csf/api/secondHolder/edit',
    method: 'put',
    data: data
  })
}
// 预约-提交受益人模块
export function editBeneficiaryInfo(data) {
  return request({
    url: '/csf/api/beneficiary/batch/edit',
    method: 'put',
    data: data
  })
}
// 删除单个受益人
export function delBeneficiary(beneficiaryBizId) {
  return request({
    url: '/csf/api/beneficiary/del?beneficiaryBizId=' + beneficiaryBizId,
    method: 'delete'
  })
}
// 预约-编辑关联FNA
export function editFna(data) {
  return request({
    url: '/csf/api/appointment/edit/fna',
    method: 'put',
    data: data
  })
}
// 预约-解除关联FNA
export function unlinkFna(data) {
  return request({
    url: '/csf/api/appointment/remove/fna',
    method: 'put',
    data: data
  })
}
// 预约-编辑转保声明
export function editPolicytransfer(data) {
  return request({
    url: '/csf/api/appointment/edit/policy/transfer',
    method: 'put',
    data: data
  })
}
// 新增附件
export function addFile(data) {
  return request({
    url: '/csf/api/appointmentFile/add',
    method: 'post',
    data: data
  })
}
// 附件列表
export function getAppointmentFile(data) {
  return request({
    url: '/csf/api/appointmentFile/page',
    method: 'post',
    data: data
  })
}
// 上传Execl
export function uploadExcel(data) {
  return request({
    url: '/csf/api/appointmentFile/excel/import/appointment',
    method: 'post',
    data: data,
    // 重要：不要手动设置 Content-Type，让浏览器自动设置
    headers: {
      // 如果您的请求拦截器中有默认的 Content-Type，可能需要覆盖
      'Content-Type': 'multipart/form-data'
    }
  })
}
// 删除单个附件
export function delFile(appointmentFileBizId) {
  return request({
    url: '/csf/api/appointmentFile/del?appointmentFileBizId=' + appointmentFileBizId,
    method: 'delete'
  })
}
// 删除单个预约
export function delSigleAppointment(appointmentBizId) {
  return request({
    url: '/csf/api/appointment/del?appointmentBizId=' + appointmentBizId,
    method: 'delete'
  })
}
