import { signName } from '../../api/sign/underwritingMain'

const useDictStore = defineStore('dict', {
  state: () => ({
    dict: new Array(),
    tenantUserList: [], //租户用户数据
    insureProductList: [], //保险产品数据
    additionalProductList: [], //附加险产品数据
    insureCompanyList: [], //保险公司数据
    clientUserList: [], //用户数据，转介人
    dictTypeLists: [], //字典列表，根据请求得不同会变化，所以使用之前需要使用useDictLists请求数据
    signNameList: [],
    bankList: [], //银行列表
    userSaleExpandList: [], //最新转介人列表
    productAdditionalList: [], //附加险产品列表对应的是产品计划
    signPeopleList: [], //所有签单员
    allTeaList: [], //所有团队
    allInsuranceCompanyList: [] //最新的保险公司列表
  }),
  actions: {
    // 获取字典
    getDict(_key) {
      if (_key == null && _key == '') {
        return null
      }
      try {
        for (let i = 0; i < this.dict.length; i++) {
          if (this.dict[i].key == _key) {
            return this.dict[i].value
          }
        }
      } catch (e) {
        return null
      }
    },
    // 设置字典
    setDict(_key, value) {
      if (_key !== null && _key !== '') {
        this.dict.push({
          key: _key,
          value: value
        })
      }
    },
    // 删除字典
    removeDict(_key) {
      var bln = false
      try {
        for (let i = 0; i < this.dict.length; i++) {
          if (this.dict[i].key == _key) {
            this.dict.splice(i, 1)
            return true
          }
        }
      } catch (e) {
        bln = false
      }
      return bln
    },
    // 清空字典
    cleanDict() {
      this.dict = new Array()
    },
    // 初始字典
    initDict() {},
    // 设置租户用户列表
    setTenantUserList(user) {
      this.tenantUserList = user
    },
    // 设置保险产品列表
    setInsureProductList(product) {
      this.insureProductList = product
    },
    // 设置附加险产品列表
    setAdditionalProductList(product) {
      this.additionalProductList = product
    },
    // 设置保险公司列表
    setInsureCompanyList(company) {
      this.insureCompanyList = company
    },
    // 设置用户列表
    setClientUserList(user) {
      this.clientUserList = user
    },
    // 设置字典列表
    setDictTypeLists(typeList) {
      this.dictTypeLists = typeList
    },
    // 设置签单人姓名列表
    setSignNameList(nameList) {
      this.signNameList = nameList
    },
    //设置银行列表
    setBankList(list) {
      this.bankList = list
    },
    //设置最新转介人列表
    setUserSaleExpandList(list) {
      this.userSaleExpandList = list
    },
    //设置最新的附加险产品列表
    setProductAdditionalList(list) {
      this.productAdditionalList = list
    },
    //设置签单员列表
    setSignPeopleList(list) {
      this.signPeopleList = list
    },
    //设置团队列表
    setAllTeaList(list) {
      this.allTeaList = list
    },
    //设置最新的保险公司列表
    setAllInsuranceCompanyList(list) {
      this.allInsuranceCompanyList = list
    }
  }
})

export default useDictStore
