import request from '@/utils/request'

// 修改上传图片方法，添加正确的请求配置
export function uploadImage(data) {
  console.log('data', data)
  return request({
    url: '/oss/api/oss/upload',
    data: data,
    method: 'post',
    // 添加以下配置
    headers: {
      'Content-Type': 'multipart/form-data' // 明确指定为multipart类型
    },
    // 如果使用axios，需要设置这个参数
    transformRequest: [
      function (data) {
        return data
      }
    ]
  })
}
// 获取系统左侧菜单
export function getMenuLists(projectBizId, tenantBizId) {
  return request({
    url: `/user/api/sysUser/login/permission/project/getMenuRouters?projectBizId=${projectBizId}&tenantBizId=${tenantBizId}`,
    method: 'get'
  })
}
// 用token获取用户详细信息
export function getUserInfo(token) {
  return request({
    url: `/user/api/sysUser/getUserInfoByToken?token=${token}`,
    method: 'get'
  })
}
// 获取国家地区信息
export function getCountryInfo() {
  return request({
    url: `/user/api/mdCountry/group`,
    method: 'get'
  })
}
// 搜索国家地区信息
export function getSearchCountry(name) {
  return request({
    url: `/user/api/mdCountry/search?name=${name}`,
    method: 'get'
  })
}
// 查询租户用户关系列表
export function listTenantUser(data) {
  return request({
    url: '/user/api/relTenantUser/page',
    method: 'post',
    data: data
  })
}
// 查询多个字典列表
export function getMoreDicts(data) {
  return request({
    url: '/user/api/sysDict/type/list',
    method: 'post',
    data: data
  })
}
// 查询保险产品列表
export function getInsuranceProductList(data) {
  return request({
    url: '/insurance/base/api/insuranceProduct/page',
    method: 'post',
    data: data
  })
}
// 查询保险附加产品列表
export function getAdditionalProductList(data) {
  return request({
    url: '/insurance/base/api/insuranceAdditionalProduct/page',
    method: 'post',
    data: data
  })
}
//获取保险公司列表
export function getAllCompanys(data) {
  return request({
    url: '/user/api/sysDept/company/page',
    method: 'post',
    data: data
  })
}
//获取转介人列表
export function getClientUser(data) {
  return request({
    url: '/user/api/clientUser/page',
    method: 'post',
    data: data
  })
}
