import dayjs from 'dayjs'

export function formatIsoToDateTime(isoStr) {
  // 处理 null/undefined 情况，避免报错
  if (!isoStr) return undefined
  // 替换 T 为空格，返回 "YYYY-MM-DD HH:mm:ss"
  return isoStr.replace('T', ' ')
}
console.log(dayjs)

const DATE_TIME_FORMAT = 'YYYY-MM-DD HH:mm:ss'
const DATE_FORMAT = 'YYYY-MM-DD'

export function formatToDateTime(date, format = DATE_TIME_FORMAT) {
  return dayjs(date).format(format)
}

export function formatToDate(date, format = DATE_FORMAT) {
  if (!date) return ''
  return dayjs(date).format(format)
}
export const getNowTime = (format = DATE_TIME_FORMAT) => {
  return dayjs().format(format)
}
