const productPlan = [
  {
    fatherTitle: '基础信息',
    keyType: 'Object', //用于表单收集值时，判断是数组还是对象
    key: 'apiProductPlanMainInfoDto',
    anchorKey: 'apiProductPlanMainInfoDto',
    showMoudle: true, //模块是否展示
    showTable: false, //是否展示表格
    fatherRequired: true, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        label: '保险公司',
        key: 'companyName',
        domType: 'SearchSelect',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        labelPosition: 'top', //标签的位置
        lg: 8 //栅格布局份数
      },
      {
        label: '保险种类',
        key: 'insuranceTypeName',
        domType: 'SearchSelect',
        required: true,

        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        labelPosition: 'top', //标签的位置
        lg: 8 //栅格布局份数
      },
      {
        label: '产品名称',
        key: 'productLaunchName',
        domType: 'SearchSelect',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        labelPosition: 'top', //标签的位置
        lg: 8 //栅格布局份数
      },
      {
        label: '供款期数',
        key: 'issueNumber',
        domType: 'Select',
        required: true,
        placeholder: '请选择',
        dictType: 'issueNumber',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保障年期',
        key: 'guaranteePeriod',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保单币种',
        key: 'policyCurrency',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'bx_currency_type',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '付款频率',
        key: 'paymentFrequency',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_frequency',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '每期保费',
        key: 'eachIssuePremium',
        domType: 'Input',
        inputType: 'number',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '首期付款方式',
        key: 'initialPaymentMethod',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_first_issue',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保单征费',
        key: 'policyLevy',
        domType: 'Input',
        inputType: 'number',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否预缴',
        key: 'isPrepay',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否追溯',
        key: 'isTraceable',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保单日期回溯',
        key: 'isBacktrack',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否参加递增保障权益',
        key: 'isJoin',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '红利分配方式',
        key: 'dividendDistributionMethod',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_dividend',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '续期付款方式',
        key: 'renewalPaymentMethod',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_first_issue',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保单额度(重疾)',
        key: 'sumInsured',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: false,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  //附加险
  {
    showMoudle: true, //模块是否展示
    fatherTitle: '附加计划',
    keyType: 'Array', //用于表单收集值时，判断是数组还是对象
    key: 'apiProductPlanAdditionalInfoDtoList',
    anchorKey: 'apiProductPlanAdditionalInfoDtoList',
    fatherRequired: true, //父级必填,代表个人资料这个模块有必填项
    addChildren: true,
    addChildrenTxt: '新增附加险',
    showTable: true, //是否展示表格
    data: [],
    columns: [
      {
        label: '产品名称',
        prop: 'productLaunchNameValue',
        type: 'text'
      },
      {
        label: '供款期数',
        prop: 'issueNumber',
        type: 'text'
      },
      {
        label: '保障年期',
        prop: 'guaranteePeriod',
        type: 'text'
      },
      {
        label: '保单币种',
        prop: 'policyCurrency',
        type: 'text'
      },
      {
        label: '保单额度',
        prop: 'sumInsured',
        type: 'text'
      },
      {
        label: '每期保费',
        prop: 'eachIssuePremium',
        type: 'text'
      },
      {
        label: '保障级别',
        prop: 'protectionLevel',
        type: 'text'
      },
      {
        label: '自付额',
        prop: 'deductibles',
        type: 'text'
      },
      {
        label: '附加保障',
        prop: 'additionalSafeguards',
        type: 'text'
      }
    ],
    // 弹窗表单的配置
    formItem: [
      {
        label: '产品名称',
        value: '',
        key: 'productLaunchName',
        domType: 'SearchSelect',
        required: false,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        labelPosition: 'top', //标签的位置
        lg: 8 //栅格布局份数
      },
      {
        label: '供款期数',
        key: 'issueNumber',
        value: '',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'issueNumber',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保障年期(若是终身，输入999)',
        key: 'guaranteePeriod',
        value: '',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保单币种',
        key: 'policyCurrency',
        value: '',
        domType: 'Select',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        dictType: 'bx_currency_type',
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保单额度(重疾)',
        key: 'sumInsured',
        value: '',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: false,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '每期保费',
        key: 'eachIssuePremium',
        value: '',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '保障地区',
        key: 'guaranteeRegion',
        value: '',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '保障级别',
        value: '',
        key: 'protectionLevel',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '自付额',
        value: '',
        key: 'deductibles',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '附加保障',
        value: '',
        key: 'additionalSafeguards',
        domType: 'Input',
        inputType: 'textarea',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 24, //栅格布局份数
        lg: 24 //栅格布局份数
      }
    ]
  }
]
export default productPlan
