import router from './router'
import { ElMessage } from 'element-plus'
import NProgress from 'nprogress'
import 'nprogress/nprogress.css'
import { isHttp, isPathMatch } from '@/utils/validate'
import { isRelogin } from '@/utils/request'
import useUserStore from '@/store/modules/user' // 使用命名导入
import useSettingsStore from '@/store/modules/settings' // 使用命名导入
import usePermissionStore from '@/store/modules/permission' // 使用命名导入
import { getToken, setToken, removeToken } from '@/utils/auth'
import { de } from 'element-plus/es/locales.mjs'

NProgress.configure({ showSpinner: false })

const whiteList = ['/login', '/register', '/workbench']

const isWhiteList = path => {
  return whiteList.some(pattern => isPathMatch(pattern, path))
}

router.beforeEach((to, from, next) => {
  // 带token是从外部跳转进系统的
  if (to.query.token) {
    removeToken()
    setToken(to.query.token)
    useUserStore().setProjectInfo({
      tenantBizId: to.query.tenantBizId,
      projectBizId: to.query.projectBizId
    })
    localStorage.setItem(
      'projectInfo',
      JSON.stringify({
        tenantBizId: to.query.tenantBizId,
        projectBizId: to.query.projectBizId
      })
    )
  }
  if (localStorage.getItem('projectInfo')) {
    useUserStore().setProjectInfo(JSON.parse(localStorage.getItem('projectInfo')))
  }
  NProgress.start()
  if (getToken()) {
    to.meta.title && useSettingsStore().setTitle(to.meta.title)
    /* has token*/
    if (to.path === '/login') {
      next({ path: '/' })
      NProgress.done()
    } else if (isWhiteList(to.path)) {
      if (useUserStore().roles.length === 0) {
        isRelogin.show = true

        // 判断当前用户是否已拉取完user_info信息
        useUserStore()
          .getInfo()
          .then(() => {
            isRelogin.show = false
            usePermissionStore()
              .generateRoutes()
              .then(accessRoutes => {
                // 根据roles权限生成可访问的路由表
                accessRoutes.forEach(route => {
                  if (!isHttp(route.path)) {
                    router.addRoute(route) // 动态添加可访问路由表
                  }
                })
                next() // hack方法 确保addRoutes已完成
              })
          })
          .catch(err => {
            useUserStore()
              .logOut()
              .then(() => {
                ElMessage.error(err)
                next({ path: '/' })
              })
          })
      } else {
        next()
      }
    } else {
      if (useUserStore().roles.length === 0) {
        isRelogin.show = true

        // 判断当前用户是否已拉取完user_info信息
        useUserStore()
          .getInfo()
          .then(() => {
            isRelogin.show = false
            usePermissionStore()
              .generateRoutes()
              .then(accessRoutes => {
                // 根据roles权限生成可访问的路由表
                accessRoutes.forEach(route => {
                  if (!isHttp(route.path)) {
                    router.addRoute(route) // 动态添加可访问路由表
                  }
                })
                // next({ path: '/' })
                next({ ...to, replace: true }) // hack方法 确保addRoutes已完成
              })
          })
          .catch(err => {
            useUserStore()
              .logOut()
              .then(() => {
                ElMessage.error(err)
                next({ path: '/' })
              })
          })
      } else {
        next()
      }
    }
  } else {
    // 没有token
    if (isWhiteList(to.path)) {
      // 在免登录白名单，现在先跳回中台，后续根据具体需求在改动
      // next()
      window.open(`${import.meta.env.VITE_APP_BASE_API1}/login?redirect=/workbench`)
      // 然后立刻关闭自己
      window.close()
    } else {
      // next(`/login?redirect=${to.fullPath}`) // 否则全部重定向到登录页
      window.open(`${import.meta.env.VITE_APP_BASE_API1}/login?redirect=/workbench`)
      // 然后立刻关闭自己
      window.close()
      NProgress.done()
    }
  }
})

router.afterEach(() => {
  NProgress.done()
})
