import request from '@/utils/request'

// 查询租户项目关系列表
export function listTenantProject(data) {
    return request({
        url: '/user/api/relTenantProject/page',
        method: 'post',
        data: data
    })
}
// 查询导入项目关系列表
export function listImportTenantProject(data) {
    return request({
        url: '/user/api/relTenantProject/select/project/page',
        method: 'post',
        data: data
    })
}
// 导入项目列表数据提交
export function addImportTenantProjectList(importTenantProjectListIds, tenantBizId) {
    const data = {
        projectBizIdList: importTenantProjectListIds,
        tenantBizId: tenantBizId
    }
    return request({
        url: '/user/api/relTenantProject/add/project/list',
        method: 'post',
        data: data
    })
}
// 删除租户和项目关系
export function delRelTenantProject(id) {
    return request({
        url: '/user/api/relTenantProject/del?id=' + id,
        method: 'delete'
    })
}


// 查询租户用户关系列表
export function listTenantUser(data) {
    return request({
        url: '/user/api/relTenantUser/page',
        method: 'post',
        data: data
    })
}
// 查询导入用户关系列表
export function listImportTenantUser(data) {
    return request({
        url: '/user/api/relTenantUser/select/user/page',
        method: 'post',
        data: data
    })
}
// 导入用户列表数据提交
export function addImportTenantUserList(importTenantUserListIds, tenantBizId) {
    const data = {
        userBizIdList: importTenantUserListIds,
        tenantBizId: tenantBizId
    }
    return request({
        url: '/user/api/relTenantUser/add/user/list',
        method: 'post',
        data: data
    })
}
// 删除租户和用户关系
export function delRelTenantUser(id) {
    return request({
        url: '/user/api/relTenantUser/del?id=' + id,
        method: 'delete'
    })
}


// 查询租户角色关系列表
export function listTenantRole(data) {
    return request({
        url: '/user/api/relTenantRole/page',
        method: 'post',
        data: data
    })
}
// 删除租户和角色关系
export function delRelTenantRole(id) {
    return request({
        url: '/user/api/relTenantRole/del?id=' + id,
        method: 'delete'
    })
}
// 查询导入角色关系列表
export function listImportTenantRole(data) {
    return request({
        url: '/user/api/relTenantRole/select/role/page',
        method: 'post',
        data: data
    })
}
// 导入角色列表数据提交
export function addImportTenantRoleList(importTenantRoleListIds, tenantBizId) {
    const data = {
        roleBizIdList: importTenantRoleListIds,
        tenantBizId: tenantBizId
    }
    return request({
        url: '/user/api/relTenantRole/add/role/list',
        method: 'post',
        data: data
    })
}

// 查询租户和菜单关系列表
export function listMenu(data) {
    return request({
        url: '/user/api/relTenantMenu/page',
        method: 'post',
        data: data
    })
}

// 获取租户菜单导入的菜单树
export function getMenuTree(tenantBizId) {
    const data = {
        tenantBizId: tenantBizId
    }
    return request({
        url: '/user/api/relTenantMenu/import/query/menu/tree',
        method: 'post',
        data: data
    })
}
// 获取租户菜单导入选中的菜单列表
export function getImportSelectedMenuList(tenantBizId) {
    return request({
        url: '/user/api/relTenantMenu/import/query/selected/menu/list?tenantBizId=' + tenantBizId,
        method: 'get'
    })
}
// 导入菜单列表数据提交
export function addImportTenantMenuList(data) {
    return request({
        url: '/user/api/relTenantMenu/add/menu/list',
        method: 'post',
        data: data
    })
}


//分配角色-左侧待选列表
export function listLeftRole(data) {
    return request({
        url: '/user/api/relUserRole/candidate/tenant/userRolePage',
        method: 'post',
        data: data
    })
}
//分配角色-右侧已选列表
export function listRightRole(data) {
    return request({
        url: '/user/api/relUserRole/selected/tenant/userRolePage',
        method: 'post',
        data: data
    })
}
//分配角色-左侧待选列表-添加用户角色列表关系
export function addRightRoleList(data) {
    return request({
        url: '/user/api/relUserRole/add/tenant/userRoleList',
        method: 'post',
        data: data
    })
}
//分配角色-右侧已选列表-移除用户角色列表关系
export function delRightRoleList(data) {
    return request({
        url: '/user/api/relUserRole/del/tenant/userRoleList',
        method: 'post',
        data: data
    })
}


//租户和菜单关系树形列表查询
export function getFpMenuTree(data) {
    return request({
        url: '/user/api/relTenantMenu/tree',
        method: 'post',
        data: data
    })
}
//租户和菜单关系树形列表查询
export function getSelectedFpMenuList(data) {
    return request({
        url: '/user/api/relRoleMenu/selected/tenant/roleMenuList',
        method: 'post',
        data: data
    })
}
//添加菜单角色列表关系
export function addFpMenuList(data) {
    return request({
        url: '/user/api/relRoleMenu/add/tenant/roleMenuList',
        method: 'post',
        data: data
    })
}


