// 深拷贝函数，避免对象引用问题
export default function deepClone(obj) {
  if (obj === null || typeof obj !== 'object') return obj
  if (obj instanceof Date) return new Date(obj.getTime())
  if (obj instanceof Array) return obj.map(item => deepClone(item))
  if (typeof obj === 'object') {
    const clonedObj = {}
    for (const key in obj) {
      if (obj.hasOwnProperty(key)) {
        clonedObj[key] = deepClone(obj[key])
      }
    }
    return clonedObj
  }
}
// 处理用户名相同的情况
export function processUserName(users) {
  const nameCountMap = new Map()

  // 统计 realName 重复情况
  users.forEach(user => {
    if (!nameCountMap.has(user.realName)) {
      nameCountMap.set(user.realName, new Set())
    }
    nameCountMap.get(user.realName).add(user.userBizId)
  })

  // 处理 showName
  return users.map(user => {
    const userBizIds = nameCountMap.get(user.realName)
    const needDistinguish = userBizIds && userBizIds.size > 1

    if (needDistinguish) {
      const mobile = user.mobile
      const prefix = mobile.substring(0, 3)
      const suffix = mobile.substring(mobile.length - 4)
      return {
        ...user,
        showName: `${user.realName} ${prefix}****${suffix}`
      }
    } else {
      return {
        ...user,
        showName: user.realName
      }
    }
  })
}
