package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 用户公共参数对象
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysUserDto {

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 用户唯一标识(业务ID)
     */
    private String userBizId;

    /**
     * 登录账号
     */
    private String userName;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 状态(0:禁用 1:正常 2:锁定)
     */
    private Integer status;

    /**
     * 是否超级管理员(0:否 1:是)
     */
    private Integer isSuperAdmin;

    /**
     * 查询是否排除当前用户唯一标识数据，默认false不排除，true的话userBizId必传
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
