package com.yd.user.feign.response.sysrole;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 获取角色详情-出参
 */
@Data
public class ApiSysRoleDetailResponse {


    private Long id;

    /**
     * 角色唯一标识(业务ID)
     */
    private String roleBizId;

    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 角色类型(1:超级管理员 2:管理员 3:普通用户)
     */
    private Integer roleType;

    /**
     * 描述
     */
    private String description;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属租户名称
     */
    private String tenantName;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

    /**
     * 所属项目名称
     */
    private String projectName;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
