package com.yd.user.feign.request.sysuser;

import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 添加用户-入参
 */
@Data
public class ApiSysUserAddRequest {

    /**
     * 当前登录用户所属的租户id（当前页面右上角显示的租户）
     */
    private String loginTenantBizId;

    /**
     * 登录用户账号
     */
    @NotBlank(message = "登录用户账号不能为空")
    private String userName;

    /**
     * 明文密码 TODO
     */
    @NotBlank(message = "密码不能为空")
    private String password;

    /**
     * 真实姓名
     */
    @NotBlank(message = "真实姓名不能为空")
    private String realName;

    /**
     * 昵称
     */
    @NotBlank(message = "昵称不能为空")
    private String nickName;

    /**
     * 头像URL
     */
    @NotBlank(message = "头像URL不能为空")
    private String avatar;

    /**
     * 邮箱
     */
    @NotBlank(message = "邮箱不能为空")
    @Email(message = "邮箱格式不正确")
    private String email;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    @Pattern(regexp = "^(?:(?:\\+|00)86)?1[3-9]\\d{9}$", message = "手机号格式不正确")
    private String mobile;

    /**
     * 性别(0:未知 1:男 2:女)
     */
    @NotNull(message = "性别不能为空")
    private Integer gender;

    /**
     * 状态(0:禁用 1:正常 2:锁定)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;
//
//    /**
//     * 用户来源(1:系统创建...)
//     */
//    @NotNull(message = "用户来源不能为空")
//    private Integer sourceType = 1;

}
