package com.yd.user.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 角色-菜单关系表（多对多关系）
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Getter
@Setter
@ToString
@TableName("rel_role_menu")
public class RelRoleMenu implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 租户ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：租户级)
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 项目ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：项目级)
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 角色ID（业务id）
     */
    @TableField("role_biz_id")
    private String roleBizId;

    /**
     * 菜单ID（业务id）
     */
    @TableField("menu_biz_id")
    private String menuBizId;

    /**
     * 状态(0:禁用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
