package com.yd.user.api.controller;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysDictService;
import com.yd.user.feign.client.sysdict.ApiSysDictFeignClient;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * 字典类型信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/sysDict")
@Validated
public class ApiSysDictController implements ApiSysDictFeignClient {

    @Autowired
    private ApiSysDictService apiSysDictService;

    /**
     * 根据字典类型获取字典数据项列表
     * @param dictType
     * @return
     */
    @Override
    public Result<List<GetDictItemListByDictTypeResponse>> getDictItemListByDictType(String dictType) {
        return apiSysDictService.getDictItemListByDictType(dictType);
    }
}
