package com.yd.user.api.feign;

import com.yd.user.api.dto.UserDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "yd-user-api", contextId = "userFeignClient")
public interface UserFeignClient {

    @GetMapping("/internal/user/findByUsername")
    UserDTO findByUsername(@RequestParam("username") String username);
}
