package com.yd.user.api.controller;

import com.yd.common.result.Result;
import com.yd.user.service.entity.User;
import com.yd.user.service.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/user")
public class UserController {

    @Autowired
    private UserService userService;

    @GetMapping("/{username}")
    public Result<User> getUserByUsername(@PathVariable String username) {
        try {
            User user = userService.findByUsername(username);
            return Result.success(user);
        } catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }

    @PostMapping("/register")
    public Result<User> registerUser(@RequestBody User user) {
        try {
            User registeredUser = userService.register(user);
            return Result.success(registeredUser);
        } catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }
    
    @GetMapping("/info")
    public Result<User> getCurrentUserInfo() {
        try {
            User currentUser = userService.getCurrentUser();
            return Result.success(currentUser);
        } catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }
}
