package com.yd.user.api;

import com.yd.common.constant.ServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication
@MapperScan("com.yd.**.mapper")
@EnableFeignClients(basePackages = "com.yd.user.api.**")
public class UserApiApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(UserApiApplication.class)
                .properties("spring.config.name:bootstrap", "config/bootstrap.yml")
                .properties("spring.application.name="+ ServerNameConstants.ydUserApi)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-user-api启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
