package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 菜单公共参数对象
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysMenuDto {

    private Long id;

    /**
     * 菜单唯一标识(业务ID)
     */
    private String menuBizId;

    /**
     * 菜单唯一标识(业务ID)集合
     */
    private List<String> menuBizIdList;

    /**
     * 父菜单ID
     */
    private String parentBizId;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 类型(1:目录 2:菜单 3:按钮)
     */
    private Integer menuType;

    /**
     * 查询是否排除当前菜单唯一标识数据，默认false不排除，true的话projectBizId必传
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
