package com.yd.user.feign.request.usersaleexpand;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiUserSaleExpandAddRequest {

    /**
     * 系统用户唯一标识(业务ID)
     */
    private String userBizId;

    /**
     * 销售用户真实姓名
     */
    @NotBlank(message = "销售用户真实姓名不能为空")
    private String realName;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String phone;

    /**
     * 邮箱
     */
    @NotBlank(message = "邮箱不能为空")
    private String email;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;
}
