package com.yd.user.feign.fallback.usersaleexpand;

import com.yd.common.result.Result;
import com.yd.user.feign.client.usersaleexpand.ApiUserSaleExpandFeignClient;
import com.yd.user.feign.request.usersaleexpand.ApiUserSaleExpandAddRequest;
import com.yd.user.feign.request.usersaleexpand.ApiUserSaleExpandEditRequest;
import com.yd.user.feign.request.usersaleexpand.ApiUserSaleExpandPageRequest;
import com.yd.user.feign.response.usersaleexpand.ApiUserSaleExpandDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 系统用户-销售用户扩展信息Feign降级处理
 */
@Slf4j
@Component
public class ApiUserSaleExpandFeignFallbackFactory implements FallbackFactory<ApiUserSaleExpandFeignClient> {
    @Override
    public ApiUserSaleExpandFeignClient create(Throwable cause) {
        return new ApiUserSaleExpandFeignClient() {
            @Override
            public Result page(ApiUserSaleExpandPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiUserSaleExpandDetailResponse> detail(String userSaleBizId) {
                return null;
            }

            @Override
            public Result add(ApiUserSaleExpandAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiUserSaleExpandEditRequest request) {
                return null;
            }

            @Override
            public Result del(String userSaleBizId) {
                return null;
            }

            @Override
            public Result editStatus(String userSaleBizId, Integer status) {
                return null;
            }
        };
    }
}
