package com.yd.user.feign.fallback.reltenantproject;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reltenantproject.ApiRelTenantProjectFeignClient;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListAddRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListPageRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectSelectPageRequest;
import com.yd.user.feign.request.reltenantproject.QueryRelTenantProjectListRequest;
import com.yd.user.feign.response.reltenantproject.QueryRelTenantProjectListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户服务：租户-项目关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelTenantProjectFeignFallbackFactory implements FallbackFactory<ApiRelTenantProjectFeignClient> {
    @Override
    public ApiRelTenantProjectFeignClient create(Throwable cause) {
        return new ApiRelTenantProjectFeignClient() {
            @Override
            public Result page(ApiRelTenantProjectListPageRequest request) {
                return null;
            }

            @Override
            public Result addProjectList(ApiRelTenantProjectListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result selectProjectPage(ApiRelTenantProjectSelectPageRequest request) {
                return null;
            }

            @Override
            public Result<List<QueryRelTenantProjectListResponse>> queryRelTenantProjectList(QueryRelTenantProjectListRequest request) {
                return null;
            }
        };
    }
}
