package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelProjectUserService;
import com.yd.user.feign.client.relprojectuser.ApiRelProjectUserFeignClient;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListAddRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListPageRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserSelectPageRequest;
import com.yd.user.feign.response.relprojectuser.ApiRelProjectUserListPageResponse;
import com.yd.user.feign.response.relprojectuser.ApiRelProjectUserSelectPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 项目-用户关系信息（租户管理->分配权限->项目->分配权限->用户配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relProjectUser")
@Validated
public class ApiRelProjectUserController implements ApiRelProjectUserFeignClient {

    @Autowired
    private ApiRelProjectUserService apiRelProjectUserService;

    /**
     * 项目用户关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectUserListPageResponse>> page(ApiRelProjectUserListPageRequest request) {
        return apiRelProjectUserService.page(request);
    }

    /**
     * 添加项目和用户列表关系
     * @param request
     * @return
     */
    @Override
    public Result addUserList(ApiRelProjectUserListAddRequest request) {
        return apiRelProjectUserService.addUserList(request);
    }

    /**
     * 删除项目和用户关系
     * @param id 项目和用户关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelProjectUserService.del(id);
    }

    /**
     * 导入-选择用户分页查询（查询用户库的用户id不在当前项目用户关系的用户id列表中的数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectUserSelectPageResponse>> selectUserPage(ApiRelProjectUserSelectPageRequest request) {
        return apiRelProjectUserService.selectUserPage(request);
    }
}
