package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptImportQueryDeptTreeRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptListPageRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptTreeListRequest;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptImportQueryDeptTreeResponse;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptListPageResponse;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptTreeListResponse;
import com.yd.user.service.dto.RelTenantDeptDto;
import com.yd.user.service.model.RelTenantDept;
import com.yd.user.service.dao.RelTenantDeptMapper;
import com.yd.user.service.model.RelTenantMenu;
import com.yd.user.service.service.IRelTenantDeptService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 租户-部门关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
@Service
public class RelTenantDeptServiceImpl extends ServiceImpl<RelTenantDeptMapper, RelTenantDept> implements IRelTenantDeptService {

    @Override
    public IPage<ApiRelTenantDeptListPageResponse> page(Page<ApiRelTenantDeptListPageResponse> page,
                                                        ApiRelTenantDeptListPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public List<ApiRelTenantDeptTreeListResponse> treeList(ApiRelTenantDeptTreeListRequest request) {
        return baseMapper.treeList(request);
    }

    /**
     * 根据租户id删除关系
     * @param tenantBizId
     * @return
     */
    @Override
    public Boolean removeByTenantBizId(String tenantBizId) {
        return this.remove(new LambdaQueryWrapper<RelTenantDept>().eq(RelTenantDept::getTenantBizId,tenantBizId));
    }

    /**
     * 查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelTenantDept queryOne(Long id) {
        return this.getById(id);
    }

    @Override
    public List<ApiRelTenantDeptImportQueryDeptTreeResponse> importQueryDeptTreeList(ApiRelTenantDeptImportQueryDeptTreeRequest request) {
        return baseMapper.importQueryDeptTreeList(request);
    }

    /**
     * 根据条件查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelTenantDept> queryList(RelTenantDeptDto dto) {
        List<RelTenantDept> list = baseMapper.selectList(new LambdaQueryWrapper<RelTenantDept>()
                .eq(!Objects.isNull(dto.getId()),RelTenantDept::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getTenantBizId()),RelTenantDept::getTenantBizId,dto.getTenantBizId())
                .eq(StringUtils.isNotBlank(dto.getDeptBizId()),RelTenantDept::getDeptBizId,dto.getDeptBizId())
        );
        return list;
    }
}
