package com.yd.user.feign.client.usersignexpand;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.usersignexpand.ApiUserSignExpandFeignFallbackFactory;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandAddRequest;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandEditRequest;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandPageRequest;
import com.yd.user.feign.response.usersignexpand.ApiUserSignExpandDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 系统用户-签单用户扩展信息Feign客户端
 */
@FeignClient(name = "yd-user-api", path = "/user/api/userSignExpand",fallbackFactory = ApiUserSignExpandFeignFallbackFactory.class)
public interface ApiUserSignExpandFeignClient {

    /**
     * 签单员分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiUserSignExpandPageRequest request);

    /**
     * 获取签单员详情
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiUserSignExpandDetailResponse> detail(@NotBlank(message = "签单员唯一标识(业务ID)不能为空") @RequestParam(value = "userSignBizId") String userSignBizId);

    /**
     * 添加签单员
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiUserSignExpandAddRequest request);

    /**
     * 编辑签单员
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiUserSignExpandEditRequest request);


    /**
     * 删除签单员（逻辑删除）
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "userSignBizId") String userSignBizId);

    /**
     * 编辑签单员状态
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "签单员唯一标识(业务ID)不能为空") @RequestParam(value = "userSignBizId") String userSignBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);

}
