package com.yd.user.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListAddRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListPageRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectSelectPageRequest;
import com.yd.user.feign.request.reltenantproject.QueryRelTenantProjectListRequest;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectListPageResponse;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectSelectPageResponse;
import com.yd.user.feign.response.reltenantproject.QueryRelTenantProjectListResponse;

import java.util.List;

public interface ApiRelTenantProjectService {

    Result<IPage<ApiRelTenantProjectListPageResponse>> page(ApiRelTenantProjectListPageRequest request);

    Result addProjectList(ApiRelTenantProjectListAddRequest request);

    Result del(Long id);

    Result<IPage<ApiRelTenantProjectSelectPageResponse>> selectProjectPage(ApiRelTenantProjectSelectPageRequest request);

    Result addSingleRel(String tenantBizId,String projectBizId);

    Result delRelByProjectBizId(String projectBizId);

    Result delRelByProjectBizIdNeTenantBizIdList(String projectBizId, List<String> tenantBizIdList);

    Result delRelByTenantBizId(String tenantBizId);

    Result<List<QueryRelTenantProjectListResponse>> queryRelTenantProjectList(QueryRelTenantProjectListRequest request);
}
