package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysProjectService;
import com.yd.user.feign.client.sysproject.ApiSysProjectFeignClient;
import com.yd.user.feign.request.sysproject.ApiSysProjectAddRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectEditRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectListRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectPageRequest;
import com.yd.user.feign.response.sysproject.ApiSysProjectDetailResponse;
import com.yd.user.feign.response.sysproject.ApiSysProjectPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 项目信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/sysProject")
@Validated
public class ApiSysProjectController implements ApiSysProjectFeignClient {

    @Autowired
    private ApiSysProjectService apiSysProjectService;

    /**
     * 项目分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysProjectPageResponse>> page(ApiSysProjectPageRequest request) {
        return apiSysProjectService.page(request);
    }

    /**
     * 项目列表查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiSysProjectDetailResponse>> list(ApiSysProjectListRequest request) {
        return apiSysProjectService.list(request);
    }

    /**
     * 获取项目详情
     * @param projectBizId 项目唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiSysProjectDetailResponse> detail(String projectBizId) {
        return apiSysProjectService.detail(projectBizId);
    }

    /**
     * 添加项目
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysProjectAddRequest request) {
        return apiSysProjectService.add(request);
    }

    /**
     * 编辑项目
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysProjectEditRequest request) {
        return apiSysProjectService.edit(request);
    }

    /**
     * 删除项目（逻辑删除） TODO
     * @param projectBizId 项目唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String projectBizId) {
        return null;
    }

    /**
     * 编辑项目状态
     * @param projectBizId 项目唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String projectBizId, Integer status) {
        return apiSysProjectService.editStatus(projectBizId,status);
    }
}
