package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelUserRoleService;
import com.yd.user.feign.client.reluserrole.ApiRelUserRoleFeignClient;
import com.yd.user.feign.request.reluserrole.*;
import com.yd.user.feign.response.reluserrole.ApiCandidateProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiCandidateTenantUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRolePageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 用户-角色关系信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relUserRole")
@Validated
public class ApiRelUserRoleController implements ApiRelUserRoleFeignClient {

    @Autowired
    private ApiRelUserRoleService apiRelUserRoleService;

    /**
     * 租户管理-用户配置-分配角色-添加用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addTenantUserRoleList(ApiTenantUserRoleListAddRequest request){
        return apiRelUserRoleService.addTenantUserRoleList(request);
    }

    /**
     * 租户管理-用户配置-分配角色-移除用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result delTenantUserRoleList(ApiTenantUserRoleListDelRequest request) {
        return apiRelUserRoleService.delTenantUserRoleList(request);
    }

    /**
     * 租户管理-用户配置-分配角色-查询待选的角色分页列表
     * @return
     */
    @Override
    public Result<IPage<ApiCandidateTenantUserRolePageResponse>> candidateTenantUserRolePage(ApiCandidateTenantUserRolePageRequest request){
        return apiRelUserRoleService.candidateTenantUserRolePage(request);
    }

    /**
     * 租户管理-用户配置-分配角色-查询选中的角色分页列表
     * @return
     */
    @Override
    public Result<IPage<ApiSelectedTenantUserRolePageResponse>> selectedTenantUserRolePage(ApiSelectedTenantUserRolePageRequest request){
        return apiRelUserRoleService.selectedTenantUserRolePage(request);
    }

    /**
     * 项目管理-用户配置-分配角色-添加用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProjectUserRoleList(ApiProjectUserRoleListAddRequest request){
        return apiRelUserRoleService.addProjectUserRoleList(request);
    }

    /**
     * 项目管理-用户配置-分配角色-移除用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result delProjectUserRoleList(ApiProjectUserRoleListDelRequest request) {
        return apiRelUserRoleService.delProjectUserRoleList(request);
    }

    /**
     * 项目管理-用户配置-分配角色-查询待选的角色分页列表
     * @return
     */
    @Override
    public Result<IPage<ApiCandidateProjectUserRolePageResponse>> candidateProjectUserRolePage(ApiCandidateProjectUserRolePageRequest request){
        return apiRelUserRoleService.candidateProjectUserRolePage(request);
    }

    /**
     * 项目管理-用户配置-分配角色-查询选中的角色列表
     * @return
     */
    @Override
    public Result<IPage<ApiSelectedProjectUserRolePageResponse>> selectedProjectUserRolePage(ApiSelectedProjectUserRolePageRequest request){
        return apiRelUserRoleService.selectedProjectUserRolePage(request);
    }
}
