package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.user.api.service.ApiUserSignExpandService;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandAddRequest;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandEditRequest;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandPageRequest;
import com.yd.user.feign.response.usersignexpand.ApiUserSignExpandDetailResponse;
import com.yd.user.feign.response.usersignexpand.ApiUserSignExpandPageResponse;
import com.yd.user.service.model.UserSignExpand;
import com.yd.user.service.service.IUserSignExpandService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Objects;

@Slf4j
@Service
public class ApiUserSignExpandServiceImpl implements ApiUserSignExpandService {

    @Autowired
    private IUserSignExpandService iUserSignExpandService;

    /**
     * 签单员分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiUserSignExpandPageResponse>> page(ApiUserSignExpandPageRequest request) {
        Page<ApiUserSignExpandPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiUserSignExpandPageResponse> iPage = iUserSignExpandService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 获取签单员详情
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiUserSignExpandDetailResponse> detail(String userSignBizId) {
        Result<UserSignExpand> result = checkUserSignExpandIsExist(userSignBizId);
        UserSignExpand userSignExpand = result.getData();
        ApiUserSignExpandDetailResponse response = new ApiUserSignExpandDetailResponse();
        BeanUtils.copyProperties(userSignExpand,response);
        return Result.success(response);
    }

    /**
     * 添加签单员
     * @param request
     * @return
     */
    @Override
    public Result add(ApiUserSignExpandAddRequest request) {
        UserSignExpand userSignExpand = new UserSignExpand();
        BeanUtils.copyProperties(request,userSignExpand);
        userSignExpand.setUserSignBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_USER_SIGN_EXPAND.getCode()));
        iUserSignExpandService.saveOrUpdate(userSignExpand);
        return Result.success();
    }

    /**
     * 编辑签单员
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiUserSignExpandEditRequest request) {
        Result<UserSignExpand> result = checkUserSignExpandIsExist(request.getUserSignBizId());
        UserSignExpand userSignExpand = result.getData();
        BeanUtils.copyProperties(request,userSignExpand);
        iUserSignExpandService.saveOrUpdate(userSignExpand);
        return Result.success();
    }

    /**
     * 删除签单员（逻辑删除）
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String userSignBizId) {
        return null;
    }

    /**
     * 编辑签单员状态
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String userSignBizId, Integer status) {
        Result<UserSignExpand> result = checkUserSignExpandIsExist(userSignBizId);
        UserSignExpand userSignExpand = result.getData();
        userSignExpand.setStatus(status);
        iUserSignExpandService.saveOrUpdate(userSignExpand);
        return Result.success();
    }

    /**
     * 校验签单员是否存在
     * @param userSignBizId
     * @return
     */
    public Result<UserSignExpand> checkUserSignExpandIsExist(String userSignBizId) {
        UserSignExpand userSignExpand = iUserSignExpandService.queryOne(userSignBizId);
        if (Objects.isNull(userSignExpand)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        return Result.success(userSignExpand);
    }

}
