package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysUserService;
import com.yd.user.feign.client.sysuser.ApiSysUserFeignClient;
import com.yd.user.feign.request.sysuser.*;
import com.yd.user.feign.response.login.ApiLoginMenuInfoResponse;
import com.yd.user.feign.response.login.GetLoginInfoResponse;
import com.yd.user.feign.response.login.GetLoginPermissionProjectResponse;
import com.yd.user.feign.response.sysuser.ApiScopePageResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 用户信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/sysUser")
@Validated
public class ApiSysUserController implements ApiSysUserFeignClient {

    @Autowired
    private ApiSysUserService apiSysUserService;

    /**
     * 用户分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysUserPageResponse>> page(ApiSysUserPageRequest request) {
        return apiSysUserService.page(request);
    }

    /**
     * 添加用户
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysUserAddRequest request) {
        return apiSysUserService.add(request);
    }

    /**
     * 编辑用户
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysUserEditRequest request) {
        return apiSysUserService.edit(request);
    }

    /**
     * 获取用户详情
     * @param userBizId 用户业务唯一标识id
     * @return
     */
    public Result<ApiSysUserDetailResponse> detail(String userBizId) {
        return apiSysUserService.detail(userBizId);
    }

    /**
     * 编辑用户状态
     * @param userBizId
     * @param status
     * @return
     */
    @Override
    public Result editStatus(String userBizId,Integer status) {
        return apiSysUserService.editStatus(userBizId,status);
    }

    /**
     * 编辑用户密码
     * @return
     */
    @Override
    public Result editPwd(ApiSysUserEditPwdRequest request) {
        return apiSysUserService.editPwd(request);
    }

    /**
     * 管理端-获取用户登录后权限信息
     * @return
     */
    @Override
    public Result<GetLoginInfoResponse> getLoginInfo() {
        return apiSysUserService.getLoginInfo();
    }

    /**
     * 管理端-获取当前登录用户绑定的当前租户用户角色菜单列表
     * @return
     */
    @Override
    public Result<List<ApiLoginMenuInfoResponse>> getMenuRouters(String tenantBizId) {
        return apiSysUserService.getMenuRouters(tenantBizId);
    }

    /**
     * 权限-管理端-根据作用域分页查询租户或项目列表
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiScopePageResponse>> scopePage(ApiScopePageRequest request) {
        return apiSysUserService.scopePage(request);
    }

    /**
     * 权限-管理端-获取登录后的项目权限信息
     * @return
     */
    @Override
    public Result<GetLoginPermissionProjectResponse> getLoginPermissionProject(String tenantBizId,String projectBizId) {
        return apiSysUserService.getLoginPermissionProject(tenantBizId,projectBizId);
    }

    /**
     * 权限-管理端-获取当前登录用户绑定的当前项目用户角色菜单列表
     * @return
     */
    @Override
    public Result<List<ApiLoginMenuInfoResponse>> getProjectMenuRouters(String tenantBizId,String projectBizId) {
        return apiSysUserService.getProjectMenuRouters(tenantBizId,projectBizId);
    }

    /**
     * 权限-管理端-获取当前登录用户是否有权限访问该项目
     * @return
     */
    @Override
    public Result<Boolean> isProjectVisit(String tenantBizId,String projectBizId) {
        return apiSysUserService.isProjectVisit(tenantBizId,projectBizId);
    }

    /**
     * 权限-管理端-根据登录token获取用户详细信息
     * @return
     */
    @Override
    public Result<ApiSysUserDetailResponse> getUserInfoByToken(String token) {
        return apiSysUserService.getUserInfoByToken(token);
    }

    /**
     * 获取用户详情 body入参
     * @return
     */
    @Override
    public Result<ApiSysUserDetailResponse> detail(ApiSysUserDetailBodyRequest request) {
        return apiSysUserService.detail(request);
    }


}
