package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportPageRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserPageRequest;
import com.yd.user.feign.response.reldeptuser.ApiRelTenantDeptUserImportPageResponse;
import com.yd.user.feign.response.reldeptuser.ApiRelTenantDeptUserPageResponse;
import com.yd.user.service.model.RelDeptUser;
import com.yd.user.service.dao.RelDeptUserMapper;
import com.yd.user.service.service.IRelDeptUserService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 部门-用户关系表（多对多关系） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
@Service
public class RelDeptUserServiceImpl extends ServiceImpl<RelDeptUserMapper, RelDeptUser> implements IRelDeptUserService {

    @Override
    public IPage<ApiRelTenantDeptUserPageResponse> page(Page<ApiRelTenantDeptUserPageResponse> page,
                                                        ApiRelTenantDeptUserPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 主键拆查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelDeptUser queryOne(Long id) {
        return this.getById(id);
    }

    @Override
    public IPage<ApiRelTenantDeptUserImportPageResponse> importPage(Page<ApiRelTenantDeptUserImportPageResponse> page,
                                                                    ApiRelTenantDeptUserImportPageRequest request) {
        return baseMapper.importPage(page,request);
    }
}
