package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListPageRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserSelectPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserSelectPageRequest;
import com.yd.user.feign.response.relprojectuser.ApiRelProjectUserListPageResponse;
import com.yd.user.feign.response.relprojectuser.ApiRelProjectUserSelectPageResponse;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserListPageResponse;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserSelectPageResponse;
import com.yd.user.service.model.RelProjectUser;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 项目-用户关系表（多对多关系） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelProjectUserMapper extends BaseMapper<RelProjectUser> {

    IPage<ApiRelProjectUserListPageResponse> page(@Param("page") IPage<ApiRelProjectUserListPageResponse> page,
                                                  @Param("request") ApiRelProjectUserListPageRequest request);

    IPage<ApiRelProjectUserSelectPageResponse> selectUserPage(@Param("page") IPage<ApiRelProjectUserSelectPageResponse> page,
                                                              @Param("request") ApiRelProjectUserSelectPageRequest request);

}
