package com.yd.user.feign.response.reltenantdept;

import lombok.Data;
import java.util.ArrayList;
import java.util.List;

@Data
public class ApiRelTenantDeptListPageResponse {

    /**
     * 租户和部门关系主键id
     */
    private Long id;

    /**
     * 租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 部门主键id
     */
    private Long deptId;

    /**
     * 部门唯一标识(业务ID)
     */
    private String deptBizId;

    /**
     * 类型(1:部门 2:公司)
     */
    private Integer type;

    /**
     * 部门属性(0-未知 1-保险 2-中介)
     */
    private Integer attribute;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 父部门ID
     */
    private String parentBizId;

    /**
     * 显示顺序
     */
    private Integer orderNum;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    private Integer scope;

    /**
     * 子级部门
     */
    private List<ApiRelTenantDeptListPageResponse> children = new ArrayList<>();
}
