package com.yd.user.feign.request.reltenantuser;

import com.yd.common.dto.PageDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 导入-选择用户分页查询（查询用户库的用户id不在当前租户用户关系的用户id列表中的数据）入参
 */
@Data
public class ApiRelTenantUserSelectPageRequest extends PageDto {

    /**
     * 租户唯一标识(业务ID)
     */
    @NotBlank(message = "租户唯一标识(业务ID)不能为空")
    private String tenantBizId;

    /**
     * 登录账号
     */
    private String userName;

    /**
     * 真实姓名
     */
    private String realName;

    /**
     * 手机号
     */
    private String mobile;

}
