package com.yd.user.feign.request.relprojectrole;

import com.yd.common.dto.PageDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 导入-选择角色分页查询（查询当前项目级（当前所属项目绑定的角色）或者系统级（全局角色在任何地方都适用导入绑定）的角色表数据）入参
 */
@Data
public class ApiRelProjectRoleSelectPageRequest extends PageDto {

    /**
     * 租户唯一标识(业务ID)
     */
    @NotBlank(message = "租户唯一标识(业务ID)不能为空")
    private String tenantBizId;

    /**
     * 项目唯一标识(业务ID)
     */
    @NotBlank(message = "项目唯一标识(业务ID)不能为空")
    private String projectBizId;

    /**
     * 角色名称
     */
    private String roleName;
}
