package com.yd.user.feign.fallback.sysdict;

import com.yd.common.result.Result;
import com.yd.user.feign.client.sysdict.ApiSysDictFeignClient;
import com.yd.user.feign.request.sysdict.ApiUpdateRedisDictListRequest;
import com.yd.user.feign.request.sysdict.GetDictTypeListRequest;
import com.yd.user.feign.response.sysdict.ApiUpdateRedisDictListResponse;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import com.yd.user.feign.response.sysdict.GetDictTypeListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 用户服务-字典类型信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSysDictFeignFallbackFactory implements FallbackFactory<ApiSysDictFeignClient> {
    @Override
    public ApiSysDictFeignClient create(Throwable cause) {
        return new ApiSysDictFeignClient() {
            @Override
            public Result<List<GetDictItemListByDictTypeResponse>> getDictItemListByDictType(String dictType) {
                return null;
            }

            @Override
            public Result<List<GetDictTypeListResponse>> getByDictTypeList(GetDictTypeListRequest request) {
                return null;
            }

            @Override
            public Result<ApiUpdateRedisDictListResponse> updateRedisDictList(ApiUpdateRedisDictListRequest request) {
                return null;
            }
        };
    }
}
