package com.yd.user.feign.client.relrolemenu;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.relrolemenu.ApiRelRoleMenuFeignFallbackFactory;
import com.yd.user.feign.request.relrolemenu.ApiProjectRoleMenuListAddRequest;
import com.yd.user.feign.request.relrolemenu.ApiSelectedProjectRoleMenuListRequest;
import com.yd.user.feign.request.relrolemenu.ApiSelectedTenantRoleMenuListRequest;
import com.yd.user.feign.request.relrolemenu.ApiTenantRoleMenuListAddRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import java.util.List;

/**
 * 用户服务：角色-菜单关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelRoleMenuFeignFallbackFactory.class)
public interface ApiRelRoleMenuFeignClient {

    /**
     * 租户管理-角色配置-分配菜单-添加菜单角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/tenant/roleMenuList")
    Result addTenantRoleMenuList(@Validated @RequestBody ApiTenantRoleMenuListAddRequest request);

    /**
     * 租户管理-角色配置-分配菜单-查询选中的菜单列表
     * @return
     */
    @PostMapping("/selected/tenant/roleMenuList")
    Result<List<String>> selectedTenantRoleMenuList(@Validated @RequestBody ApiSelectedTenantRoleMenuListRequest request);

    /**
     * 项目管理-角色配置-分配菜单-添加菜单角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/project/roleMenuList")
    Result addProjectRoleMenuList(@Validated @RequestBody ApiProjectRoleMenuListAddRequest request);

    /**
     * 项目管理-角色配置-分配菜单-查询选中的菜单列表
     * @return
     */
    @PostMapping("/selected/project/roleMenuList")
    Result<List<String>> selectedProjectRoleMenuList(@Validated @RequestBody ApiSelectedProjectRoleMenuListRequest request);
}
