package com.yd.user.feign.client.mdCountry;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.mdcountry.ApiMdCountryFeignFallbackFactory;
import com.yd.user.feign.response.mdCountry.ApiMdCountryGroupResponse;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

@FeignClient(name = "yd-user-api", fallbackFactory = ApiMdCountryFeignFallbackFactory.class)
public interface ApiMdCountryFeignClient {

    /**
     * 查询所有国家地区
     * @return
     */
    @GetMapping("/group")
    @Operation(summary = "查询所有国家地区")
    Result<ApiMdCountryGroupResponse> group();
}
