package com.yd.user.api.service.impl;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiMdCountryService;

import com.yd.user.feign.response.mdCountry.ApiMdCountryGroupResponse;
import com.yd.user.feign.response.mdCountry.ApiMdCountryVO;
import com.yd.user.service.model.MdCountry;
import com.yd.user.service.service.MdCountryService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiMdCountryServiceImpl implements ApiMdCountryService {

    @Resource
    private MdCountryService mdCountryService;

    @Override
    public Result<ApiMdCountryGroupResponse> group() {
        ApiMdCountryGroupResponse response = new ApiMdCountryGroupResponse();
        // 全部国家
        List<MdCountry> list = mdCountryService.list();
        // model 转 VO
        List<ApiMdCountryVO> groupList = list.stream().map(item -> {
            ApiMdCountryVO vo = new ApiMdCountryVO();
            vo.setName(item.getName());
            vo.setCountryCode(item.getCountryCode());
            vo.setGroup(item.getGroup());
            vo.setAreaCode(item.getAreaCode());
            vo.setHotRank(item.getHotRank());
            return vo;
        }).collect(Collectors.toList());

        // 热门国家/地区
        List<ApiMdCountryVO> hotList =groupList.stream().filter(item->item.getHotRank()!=9999).collect(Collectors.toList());

        response.setHotCountries(hotList);
        response.setGroupCountries(groupList);

        return Result.success(response);
    }
}
