package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysdept.ApiSysDeptCompanyPageRequest;
import com.yd.user.feign.request.sysdept.ApiSysDeptPageRequest;
import com.yd.user.feign.response.sysdept.ApiSysDeptCompanyPageResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptPageResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptTreeListResponse;
import com.yd.user.service.dto.SysDeptDto;
import com.yd.user.service.model.SysDept;
import com.yd.user.service.dao.SysDeptMapper;
import com.yd.user.service.model.SysMenu;
import com.yd.user.service.service.ISysDeptService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 部门表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class SysDeptServiceImpl extends ServiceImpl<SysDeptMapper, SysDept> implements ISysDeptService {

    /**
     * 条件搜索构建部门树的数据
     * @param loginTenantBizId
     * @param isAdmin
     * @param deptName
     * @param projectBizIdList
     * @return
     */
    @Override
    public List<ApiSysDeptTreeListResponse> treeList(String loginTenantBizId,
                                                     Boolean isAdmin,
                                                     String deptName,
                                                     List<String> projectBizIdList) {
        return baseMapper.treeList(loginTenantBizId,isAdmin,deptName,projectBizIdList);
    }

    @Override
    public IPage<ApiSysDeptPageResponse> page(Page<ApiSysDeptPageResponse> page,
                                              ApiSysDeptPageRequest request,
                                              Boolean isAdmin,
                                              List<String> projectBizIdList,
                                              String loginTenantBizId) {
        return baseMapper.page(page,request,isAdmin,projectBizIdList,loginTenantBizId);
    }

    @Override
    public IPage<ApiSysDeptCompanyPageResponse> companyPage(Page<ApiSysDeptCompanyPageResponse> page,
                                                            ApiSysDeptCompanyPageRequest request) {
        return baseMapper.companyPage(page,request);
    }

    /**
     * 查询单个对象
     * @param deptBizId
     * @return
     */
    @Override
    public SysDept queryOne(String deptBizId) {
        return this.getOne(new LambdaQueryWrapper<SysDept>().eq(SysDept::getDeptBizId,deptBizId));
    }

    /**
     * 根据条件查询列表
     * @param dto
     * @return
     */
    @Override
    public List<SysDept> queryList(SysDeptDto dto) {
        List<SysDept> list = baseMapper.selectList(new LambdaQueryWrapper<SysDept>()
                .eq(!Objects.isNull(dto.getId()),SysDept::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getDeptBizId()) && !dto.getIsExcludeMy(),SysDept::getDeptBizId,dto.getDeptBizId())
                .eq(StringUtils.isNotBlank(dto.getDeptName()),SysDept::getDeptName,dto.getDeptName())
                .in(!CollectionUtils.isEmpty(dto.getDeptBizIdList()),SysDept::getDeptBizId,dto.getDeptBizIdList())
                .ne(dto.getIsExcludeMy(),SysDept::getDeptBizId,dto.getDeptBizId())
        );
        return list;
    }
}
