package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuTreeListRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuListPageResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuTreeListResponse;
import com.yd.user.service.dto.RelTenantMenuDto;
import com.yd.user.service.model.RelTenantMenu;
import com.yd.user.service.dao.RelTenantMenuMapper;
import com.yd.user.service.service.IRelTenantMenuService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 租户-菜单关系表（正常来说一对多，加关系表方便扩展） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class RelTenantMenuServiceImpl extends ServiceImpl<RelTenantMenuMapper, RelTenantMenu> implements IRelTenantMenuService {

    /**
     * 租户和菜单关系分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantMenuListPageResponse> page(Page<ApiRelTenantMenuListPageResponse> page,
                                                        ApiRelTenantMenuListPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public List<ApiRelTenantMenuTreeListResponse> treeList(ApiRelTenantMenuTreeListRequest request) {
        return baseMapper.treeList(request);
    }

    /**
     * 查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelTenantMenu queryOne(Long id) {
        return this.getById(id);
    }

    @Override
    public List<RelTenantMenu> queryList(RelTenantMenuDto dto) {
        List<RelTenantMenu> list = baseMapper.selectList(new LambdaQueryWrapper<RelTenantMenu>()
                .eq(!Objects.isNull(dto.getId()),RelTenantMenu::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getTenantBizId()),RelTenantMenu::getTenantBizId,dto.getTenantBizId())
                .eq(StringUtils.isNotBlank(dto.getMenuBizId()),RelTenantMenu::getMenuBizId,dto.getMenuBizId())
        );
        return list;
    }

    @Override
    public List<ApiRelTenantMenuImportQueryMenuTreeResponse> importQueryMenuTreeList(ApiRelTenantMenuImportQueryMenuTreeRequest request) {
        return baseMapper.importQueryMenuTreeList(request);
    }

    /**
     * 根据租户id删除关系
     */
    @Override
    public Boolean removeByTenantBizId(String tenantBizId) {
        return this.remove(new LambdaQueryWrapper<RelTenantMenu>().eq(RelTenantMenu::getTenantBizId,tenantBizId));
    }
}
