package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListPageRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuTreeListRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuTreeListRequest;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuListPageResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuTreeListResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuTreeListResponse;
import com.yd.user.service.dto.RelProjectMenuDto;
import com.yd.user.service.model.RelProjectMenu;
import com.yd.user.service.dao.RelProjectMenuMapper;
import com.yd.user.service.service.IRelProjectMenuService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 项目-菜单关系表（正常来说一对多，加关系表方便扩展） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class RelProjectMenuServiceImpl extends ServiceImpl<RelProjectMenuMapper, RelProjectMenu> implements IRelProjectMenuService {

    /**
     * 项目和菜单关系分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelProjectMenuListPageResponse> page(Page<ApiRelProjectMenuListPageResponse> page,
                                                         ApiRelProjectMenuListPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public List<ApiRelProjectMenuTreeListResponse> treeList(ApiRelProjectMenuTreeListRequest request) {
        return baseMapper.treeList(request);
    }

    /**
     * 查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelProjectMenu queryOne(Long id) {
        return this.getById(id);
    }

    @Override
    public List<RelProjectMenu> queryList(RelProjectMenuDto dto) {
        List<RelProjectMenu> list = baseMapper.selectList(new LambdaQueryWrapper<RelProjectMenu>()
                .eq(!Objects.isNull(dto.getId()),RelProjectMenu::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getProjectBizId()),RelProjectMenu::getProjectBizId,dto.getProjectBizId())
                .eq(StringUtils.isNotBlank(dto.getMenuBizId()),RelProjectMenu::getMenuBizId,dto.getMenuBizId())
        );
        return list;
    }

    @Override
    public List<ApiRelProjectMenuImportQueryMenuTreeResponse> importQueryMenuTreeList(ApiRelProjectMenuImportQueryMenuTreeRequest request) {
        return baseMapper.importQueryMenuTreeList(request);
    }

    /**
     * 根据项目id删除关系
     */
    @Override
    public Boolean removeByProjectBizId(String projectBizId) {
        return this.remove(new LambdaQueryWrapper<RelProjectMenu>().eq(RelProjectMenu::getProjectBizId,projectBizId));
    }
    
}
