package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuTreeListRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuListPageResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuTreeListResponse;
import com.yd.user.service.dto.RelTenantMenuDto;
import com.yd.user.service.model.RelTenantMenu;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 租户-菜单关系表（正常来说一对多，加关系表方便扩展） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface IRelTenantMenuService extends IService<RelTenantMenu> {

    IPage<ApiRelTenantMenuListPageResponse> page(Page<ApiRelTenantMenuListPageResponse> page,
                                                 ApiRelTenantMenuListPageRequest request);

    List<ApiRelTenantMenuTreeListResponse> treeList(ApiRelTenantMenuTreeListRequest request);

    RelTenantMenu queryOne(Long id);

    List<RelTenantMenu> queryList(RelTenantMenuDto dto);

    List<ApiRelTenantMenuImportQueryMenuTreeResponse> importQueryMenuTreeList(ApiRelTenantMenuImportQueryMenuTreeRequest request);

    Boolean removeByTenantBizId(String tenantBizId);
}
