package com.yd.user.feign.response.login;

import lombok.Data;

/**
 * 登录的用户信息出参
 */
@Data
public class ApiLoginUserInfoResponse {

    /**
     * 用户主键ID
     */
    private Long id;

    /**
     * 用户唯一标识(业务ID)
     */
    private String userBizId;

    /**
     * 登录账号
     */
    private String userName;

    /**
     * 加密密码
     */
    private String password;

    /**
     * 密码盐值
     */
    private String passwordSalt;

    /**
     * 真实姓名
     */
    private String realName;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 头像URL
     */
    private String avatar;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 性别(0:未知 1:男 2:女)
     */
    private Integer gender;

    /**
     * 状态(0:禁用 1:正常 2:锁定)
     */
    private Integer status;

    /**
     * 是否超级管理员(0:否 1:是)
     */
    private Integer isSuperAdmin;

    /**
     * 用户来源(1:系统创建...)
     */
    private Integer sourceType;
}
