package com.yd.user.feign.request.reltenantuser;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 添加租户和用户列表关系入参
 */
@Data
public class ApiRelTenantUserListAddRequest {

    /**
     * 租户ID（业务id）
     */
    @NotBlank(message = "租户ID（业务id）不能为空")
    private String tenantBizId;

    /**
     * 选择的用户ID（业务id）列表
     */
    @NotEmpty(message = "选择的用户ID（业务id）列表不能为空")
    private List<String> userBizIdList;
}
